import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface IndexCardState {
  id: number | null;
  title: string;
  image: string;
  category_id: string;
}

const initialState: IndexCardState = {
  id: null,
  title: "",
  image: "",
  category_id: "",
};

const indexCardSlice = createSlice({
  name: "indexCard",
  initialState,
  reducers: {
    setIndexCardData(state, action: PayloadAction<IndexCardState>) {
      state.id = action.payload.id;
      state.title = action.payload.title;
      state.image = action.payload.image;
      state.category_id = action.payload.category_id;
    },
    clearIndexCardData(state) {
      state.id = null;
      state.title = "";
      state.image = "";
      state.category_id = "";
    },
  },
});

export const { setIndexCardData, clearIndexCardData } = indexCardSlice.actions;

export default indexCardSlice.reducer;
