import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface Category {
    id: number | string;
    [key: string]: any;
}

interface FrontendState {
    selectedCategories: Category[];
}

const initialState: FrontendState = {
    selectedCategories: [],
};

const FrontendSlice = createSlice({
    name: "FrontendSlice",
    initialState,
    reducers: {
        toggleCategorySelectionFrontEnd: (state, action: PayloadAction<Category>) => {
            const existingIndex = state.selectedCategories.findIndex(
                (category) => category.id === action.payload.id
            );

            if (existingIndex >= 0) {
                // If already selected, remove it (deselect)
                state.selectedCategories.splice(existingIndex, 1);
            } else {
                // If not selected, add to selection
                state.selectedCategories.push(action.payload);
            }
        },

        clearAllSelectedCategories: (state) => {
            state.selectedCategories = [];
        },
    },
});

export const {
    toggleCategorySelectionFrontEnd,
    clearAllSelectedCategories,
} = FrontendSlice.actions;

export default FrontendSlice.reducer;
