import { createSlice } from '@reduxjs/toolkit';
import type { PayloadAction } from '@reduxjs/toolkit';

interface Category {
  id: number;
  category_name: string;
  category_image: string;
  category_icon:string;
}

interface CategoryUpdateState {
  status: boolean;
  message: string;
  category: Category | null;

}

const initialState: CategoryUpdateState = {
  status: false,
  message: '',
  category: null,
};

const CategoryUpdateSlice = createSlice({
  name: 'CategoryUpdateSlice',
  initialState,
  reducers: {
    setCategoryUpdate(state, action: PayloadAction<CategoryUpdateState>) {
      state.status = action.payload.status;
      state.message = action.payload.message;
      state.category = action.payload.category;
       state.category  =  action.payload.category
    },
    clearCategoryUpdate(state) {
      state.status = false;
      state.message = '';
      state.category = null;
    }
  },
});

export const { setCategoryUpdate, clearCategoryUpdate } = CategoryUpdateSlice.actions;

export default CategoryUpdateSlice.reducer;
