import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  selectedCategory: null,
};

const CategorySelectedIDandValuesUpdateFronentCard4 = createSlice({
  name: "CategorySelectedIDandValuesUpdateFronentCard4",
  initialState,
  reducers: {
    toggleCategorySelectionUpdate4: (state, action) => {
      if (state.selectedCategory?.id === action.payload.id) {
        state.selectedCategory = null;
      } else {
        state.selectedCategory = action.payload;
      }
    },
    clearSelectedCategoryUpdate: (state) => {
      state.selectedCategory = null;
    },
  },
});


export const {
  toggleCategorySelectionUpdate4,
  clearSelectedCategoryUpdate,
} = CategorySelectedIDandValuesUpdateFronentCard4.actions;

export default CategorySelectedIDandValuesUpdateFronentCard4.reducer;
