import { createSlice } from "@reduxjs/toolkit";

const initialState = {
  selectedCategory: null,
};

const CategorySelectedIDandValuesUpdateFronentCard2 = createSlice({
  name: "CategorySelectedIDandValuesUpdateFronentCard2",
  initialState,
  reducers: {
    toggleCategorySelectionUpdate2: (state, action) => {
      if (state.selectedCategory?.id === action.payload.id) {
        state.selectedCategory = null;
      } else {
        state.selectedCategory = action.payload;
      }
    },
    clearSelectedCategoryUpdate: (state) => {
      state.selectedCategory = null;
    },
  },
});


export const {
  toggleCategorySelectionUpdate2,
  clearSelectedCategoryUpdate,
} = CategorySelectedIDandValuesUpdateFronentCard2.actions;

export default CategorySelectedIDandValuesUpdateFronentCard2.reducer;
