import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

interface State {
  selectedCities: string[]; // Only storing city names
}

const initialState: State = {
  selectedCities: [],
};

const BanerSelectLocation = createSlice({
  name: "BanerSelectLocation",
  initialState,
  reducers: {
    toggleCitySelection: (state, action: PayloadAction<string>) => {
      const city = action.payload;
      const index = state.selectedCities.indexOf(city);

      if (index !== -1) {
        // Already selected — remove it
        state.selectedCities.splice(index, 1);
      } else {
        // Not selected — add it
        state.selectedCities.push(city);
      }
    },
    clearSelectedCities: (state) => {
      state.selectedCities = [];
    },
    setSelectedCities: (state, action: PayloadAction<string[]>) => {
      state.selectedCities = action.payload;
    },
  },
});

export const {
  toggleCitySelection,
  clearSelectedCities,
  setSelectedCities,
} = BanerSelectLocation.actions;

export default BanerSelectLocation.reducer;
