import { createSlice } from '@reduxjs/toolkit';
const initialState = {
    fullPhoneNumber: "",
    countryCode: "",
    nationalNumber: "",
    username: "",
    isUsernameAvailable: null,
    status: null,
    duration:"",
};

const addVendorSlice = createSlice({
    name: 'addVendor',
    initialState,
    reducers: {
        setPhoneNumber: (state, action) => {
            state.fullPhoneNumber = action.payload.fullPhoneNumber || "";
            state.countryCode = action.payload.countryCode || "";
            state.nationalNumber = action.payload.nationalNumber || "";
        },
        setUsername: (state, action) => {
            state.username = action.payload;
        },
        setUsernameAvailability: (state, action) => {
            state.isUsernameAvailable = action.payload;
        },
        setStatus: (state, action) => {
            state.status = action.payload; // 1 or 0
        },

        setDuration:(state, action) => {
            state.duration = action.payload
        },

        resetall: (state) => {
            state.fullPhoneNumber = "";
            state.countryCode = "";
            state.nationalNumber = "";
            state.username = "";
            state.isUsernameAvailable = null;
            state.status = null;
            state.duration=""
        }
    },
});

export const {
    setPhoneNumber,
    setUsername,
    setUsernameAvailability,
    setStatus,
    resetall,
    setDuration
} = addVendorSlice.actions;

export default addVendorSlice.reducer;
