// AddImageSlice.ts
import { createSlice } from "@reduxjs/toolkit";
import type { PayloadAction } from "@reduxjs/toolkit";

export interface AddPostStateType {
  cover_image: File | null;
}

const initialState: AddPostStateType = {
  cover_image: null,
};

const AddImageSlice = createSlice({
  name: "AddImageSlice",
  initialState,
  reducers: {
    updateCoverImage(state, action: PayloadAction<File | null>) {
      state.cover_image = action.payload;
    },
    clearCoverImage(state) {
      state.cover_image = null;
    },
  },
});

export const { updateCoverImage, clearCoverImage } = AddImageSlice.actions;
export default AddImageSlice.reducer;
