import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { VendorRes } from "../../Types/Types";

export const UserVendorList = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<VendorRes, Error>({
        queryKey: ["vendors-listwithoutpage"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<VendorRes>(
                `${baseURL}/vendors-listwithoutpage`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
