import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { RefundPolicyRes } from "../../Types/Types";

export const useGetDataWithToken = (urlPath: string, queryKey: string[]) => {
  const baseURL = import.meta.env.VITE_API_URL;

  return useQuery<RefundPolicyRes, Error>({
    queryKey,
    queryFn: async () => {
      const token = Cookies.get("token");

      if (!token) {
        throw new Error("No token found");
      }

      const response = await axios.post<RefundPolicyRes>(
        `${baseURL}${urlPath}`,
        {}, // empty body, you can make this dynamic too if needed
        {
          headers: {
            Authorization: `Bearer ${token}`,
          },
        }
      );

      return response.data;
    },
    staleTime: Infinity,
  });
};
