import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { PaymentSetting } from "../../Types/Types";

export const UsegetPaymentSetting = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<PaymentSetting, Error>({
        queryKey: ["allpayment-gateway"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<PaymentSetting>(
                `${baseURL}/allpayment-gateway`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
