import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { GetUserDetailRes } from "../../Types/Types";

export const UseGetUserDetail = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    const user_id = sessionStorage.getItem("user_id")

    return useQuery<GetUserDetailRes, Error>({
        queryKey: ["get-userview", user_id],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<GetUserDetailRes>(
                `${baseURL}/get-userview`,
                { user_id }, // Pass user_id in the request body
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
        enabled: !!user_id, // Only run the query if user_id exists
    });
};
