import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { SubCategoryRes } from "../../Types/Types";

export const UseGetSubcategory = (category_id: number | undefined) => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<SubCategoryRes, Error>({
        queryKey: ["get-subcategory", category_id],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            if (!category_id) {
                throw new Error("No category ID provided");
            }

            const formData = new FormData();
            formData.append("category_id", category_id.toString());

            const response = await axios.post<SubCategoryRes>(
                `${baseURL}/get-subcategory`,
                formData,
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                        "Content-Type": "multipart/form-data",
                    },
                }
            );

            return response.data;
        },
        enabled: !!category_id, // only run query if category_id is available
        staleTime: Infinity,
    });
};
