import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { StoreListRes } from "../../Types/Types";

export const UseGetStoreSponcerList = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<StoreListRes, Error>({
        queryKey: ["service-listshowpage"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<StoreListRes>(
                `${baseURL}/service-listshowpage`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
