import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { StoreListRes } from "../../Types/Types";

export const UseGetStoreList = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<StoreListRes, Error>({
        queryKey: ["service-listwithoutpage"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<StoreListRes>(
                `${baseURL}/service-listwithoutpage`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },   
        staleTime: Infinity,
    });
};
