import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { CityName } from "../../Types/Types";

export const UseGetLocation = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<CityName, Error>({
        queryKey: ["unique-citylist"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<CityName>(
                `${baseURL}/unique-citylist`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },   
        staleTime: Infinity,
    });
};
