import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { CurrencyListValues } from "../../Types/Types";

export const UseGetCurrenyList = () => {
    const baseURL = import.meta.env.VITE_API_URL;

    return useQuery<CurrencyListValues, Error>({
        queryKey: ["currencies-list"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) {
                throw new Error("No token found");
            }

            const response = await axios.post<CurrencyListValues>(
                `${baseURL}/currencies-list`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
