import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { GiftCategory } from "../../../Types/Types";

export const useGetGiftCategoryValues = () => {
  const baseURL = import.meta.env.VITE_API_URL;

  return useQuery<GiftCategory, Error>({
    queryKey: ["get-category"],
    queryFn: async () => {
      const token = Cookies.get("token");
      if (!token) throw new Error("No token found");

      const res = await axios.get<GiftCategory>(`${baseURL}/get-category`, {
        headers: { Authorization: `Bearer ${token}` },
      });

      return res.data;
    },
    staleTime: Infinity,
    refetchOnWindowFocus: false,
  });
};
