import axios from "axios";
import Cookies from "js-cookie";
import { useQuery } from "@tanstack/react-query";
import type { DashboradPlatFomrActivity } from "../../../Types/Types";

export const UsegetPlatformActivity = () => {
    const baseURL =  import.meta.env.VITE_API_URL;

    return useQuery<DashboradPlatFomrActivity, Error>({
        queryKey: ["platform-data-card"],
        queryFn: async () => {
            const token = Cookies.get("token");

            if (!token) throw new Error("No token found");

            const response = await axios.post<DashboradPlatFomrActivity>(
                `${baseURL}/admin/platform-data-card`,
                {},
                {
                    headers: {
                        Authorization: `Bearer ${token}`,
                    },
                }
            );

            return response.data;
        },
        staleTime: Infinity,
    });
};
