<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('profile_blocklist', function (Blueprint $table) {
            $table->id(); // Primary key
            $table->unsignedInteger('blockedByUserId')->nullable(); // User who blocks
            $table->unsignedInteger('blockedUserId')->nullable();   // User being blocked
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Optional: Add indexes for performance
            $table->index('blockedByUserId');
            $table->index('blockedUserId');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('profile_blocklist');
    }
};
