<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_sponserstores', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement();  // Primary key: int(11) unsigned
            $table->integer('service_id', false, true)->nullable(); // Foreign key: int(11) unsigned nullable
            $table->text('title')->nullable();                   // text nullable
            $table->text('subtext')->nullable();                 // text nullable
            $table->timestamp('created_at')->nullable();         // timestamp nullable
            $table->timestamp('updated_at')->nullable();         // timestamp nullable
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_sponserstores');
    }
};
