<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('goals', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned AUTO_INCREMENT
            $table->integer('campaign_id', false, true)->length(11)->nullable(); // int(11) unsigned nullable
            $table->text('start_date')->nullable();
            $table->text('end_date')->nullable();
            $table->text('days'); // NOT NULL
            $table->text('price'); // NOT NULL
            $table->integer('status')->default(0); // NOT NULL DEFAULT 0
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('goals');
    }
};
