<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('email_otpverify', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->text('logo')->nullable();
            $table->text('title')->nullable();
            $table->text('body')->nullable();
            $table->text('section_text')->nullable();
            $table->integer('privacy_policy')->nullable()->default(0);
            $table->integer('refund_policy')->nullable()->default(0);
            $table->integer('cancellation_policy')->nullable()->default(0);
            $table->integer('contact_us')->nullable()->default(0);
            $table->integer('twitter')->nullable()->default(0);
            $table->integer('linkedIn')->nullable()->default(0);
            $table->integer('instagram')->nullable()->default(0);
            $table->integer('facebook')->nullable()->default(0);
            $table->text('copyright_content')->nullable();
            $table->integer('get_email')->default(1); // required, no NULL
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });


        // Insert default admin record
        DB::table('email_otpverify')->insert([
            'id' => 1,
            'logo' => '1742480516.png',
            'title' => 'Otp Verification',
            'body' => 'Your verification code is',
            'section_text' => "Please contact us for any queries. We' re always happy to help .",
            'privacy_policy' => 1,
            'refund_policy' => 1,
            'cancellation_policy' => 1,
            'contact_us' => 1,
            'twitter' => 1,
            'linkedIn' => 1,
            'instagram' => 1,
            'facebook' => 1,
            'copyright_content' => '2025 nlytical. All rights reserved.',
            'get_email' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('email_otpverify');
    }
};
